﻿package tm.com
{
	import br.com.stimuli.loading.BulkLoader;
	
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundTransform;
	import flash.utils.setTimeout;
	
	public class TemplateSound extends EventDispatcher
	{		
		public var sound:Sound;
		public var soundTransform:SoundTransform;
		public var soundChannel:SoundChannel;
		
		private var _soundObject:Object;
		
		public function TemplateSound( soundID:String )
		{
			sound = BulkLoader.getLoader( 'mainLoader' ).getSound( soundID );
			_soundObject = TemplateState.getInstance().sounds[ soundID ];
			
		}
		
		public function play():void
		{			
			if( sound && _soundObject ) {
				soundTransform = new SoundTransform( _soundObject.volume, _soundObject.panning );
				if( _soundObject.loops > 0 ) {
					if( _soundObject.skipFrom > 0 || _soundObject.skipTo > 0 ) {
						soundChannel = sound.play( _soundObject.skipFrom, 0, soundTransform );
						setTimeout( loopSound, _soundObject.skipTo - _soundObject.skipFrom );
					} else {
						sound.play( 0, _soundObject.loops, soundTransform );
					}
				} else {
					sound.play( 0, 0, soundTransform );
				}
			}
		}
		
		private function loopSound():void
		{
			soundChannel.stop();
			setTimeout( loopSound, _soundObject.skipTo - _soundObject.skipFrom );
			soundChannel = sound.play( _soundObject.skipFrom, 0, soundTransform );	
			
			dispatchEvent( new Event( 'soundChannelUpdated' ) );
		}
	}
}